/*******************************************************************************

    uBlock Origin Lite - a comprehensive, MV3-compliant content blocker
    Copyright (C) 2014-present Raymond Hill

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see {http://www.gnu.org/licenses/}.

    Home: https://github.com/gorhill/uBlock
*/

// annoyances-others

// Important!
// Isolate from global scope
(function uBOL_cssGenericImport() {

/******************************************************************************/

const genericSelectorMap = [[1875,"#FooterboardMobile"],[1242,"#ac-lre-player"],[1975,"#ac-lre-player-ph"],[981,"#amp-smart-banner-download,\n.body-scrollToTop"],[1723,"#article_sharing_footer"],[1022,"#cxense_widget,\n.icon--totop"],[2110,"#envato-widget"],[2359,"#feedback-bottomentry"],[3030,"#feedback_callout"],[2844,"#feedback_widget_tab"],[3354,"#feedbacklinktab"],[1588,"#feedburner_left"],[59,"#feedburner_right"],[842,"#feedburneremailwidget-3"],[3258,"#gc_message_bar"],[557,"#hellobar-container,\n#hellobar_container"],[2051,"#hellobar-takeover"],[3411,"#hellobar-wrapper,\n.cn_ecom_placement"],[3805,"#jbb_widget_customizable"],[734,"#meebo-iframe"],[1948,"#mvp-prev-next-wrap"],[881,"#noti_msg,\n#scroll_back_to_top"],[2726,"#oneSignalBell"],[3953,"#onesignal-bell-container"],[1616,"#onesignal-popover-container"],[178,"#phxtags-belowcontent"],[1641,"#piano_bottom_ribbon_wrapper,\n.UpNext-Wrapper,\n.trustpilot-widget"],[3684,"#ppsPopupBgOverlay"],[114,"#prev-next-wrap"],[2744,"#prev-post-wrap,\n.fomo-notification-container"],[3467,"#primeABBUpsell_feature_div,\n.js-s-f-back-to-top"],[3144,"#pubexchange_widget2"],[1278,"#readNextWidget,\n#gkBackToTop"],[2413,"#sdac_feedburner_widget-3"],[2595,"#simplereach-slide-element,\n.back_top_top"],[639,"#sumotest-badge"],[694,"#uservoice-feedback"],[989,"#uservoice-feedback-tab,\n.btn-pb-back-to-top"],[1963,"#widget_detail_postlinks"],[942,"#wpd-bubble-wrapper"],[2459,"#wpfront-notification-bar-spacer"],[3566,"#wpl-likebox"],[2207,"#zerg-target,\n#xb_ScrollUp"],[3278,".abicon-feed"],[1040,".android-smart-banner"],[2376,".article-next-sticky"],[3653,".bbccom_text"],[3571,".block-simplenews"],[3401,".dailydeal_wrapper"],[1879,".dd_ajax_float"],[785,".feedbackTab"],[1711,".floatingfeedback"],[2282,".fyre-notifier-container"],[3338,".grecaptcha-badge[data-style]"],[50,".gt-popup"],[314,".homeDonateCta"],[757,".house-ad-wrap,\n.stt-gototop"],[967,".inlinkz-widget"],[2758,".ione-widget-jobs"],[131,".jnews_popup_post_container"],[3127,".klarna-banner,\n.btn-scroll-to-top-container"],[905,".notifyjs-corner,\n.backtopbutton"],[2672,".ntfc_overlay"],[3785,".ntfc_popup"],[1308,".onesignal-bell-container"],[2777,".onesignal-customlink-container,\n.top-of-page-button"],[3663,".onesignal-slidedown-container"],[245,".partage_reseaux_sociaux"],[3648,".pin-it-btn-wrapper,\n#back_to_top_now"],[41,".plista-suggestions"],[928,".ppsPopupShell,\n.sticky_totop_box"],[1353,".prev-next-article"],[3234,".prevNextPost"],[1618,".readmore-pop-up"],[3489,".recommended-flyout-wrap"],[3497,".sailthruRecommendation"],[1611,".td-more-articles-box"],[103,".upNext-container"],[2281,".vf-conversation-starter,\n.go-to-top-desktop"],[2428,".vf-starter"],[2135,".widget-feedburner"],[2689,".widget_al2fb"],[2895,".widget_feedburnerformwidget"],[2986,".widget_feeds"],[3543,".widget_ione-jobs_v2"],[2370,".widget_mailster_signup"],[2633,".widget_mc4wp_widget,\n#page-go-up"],[458,".widget_mybloglog"],[2486,".widget_pushpad_widget"],[121,".widget_sdac_feedburner_widget"],[941,".widget_social_icons"],[2892,".widget_tpd_dappier_widget"],[3620,".widget_wpjb-recent-jobs"],[91,".widget_wysija"],[3112,".wpmchimpa-overlay-bg,\n.bd-backtotop-1,\n.go-top-footer-btn"],[2026,".preezie-widget-modal"],[479,"#cb-widget-sales-pop"],[711,"#goodreviews-wrapper"],[3921,"#message-purchased.wn-background-template-type-2,\n#message-purchased.wn-extended"],[2995,"#mps-sales-notification"],[58,"#recent_sales_ticker"],[307,"#sales-pop-plugin"],[3241,".cbSalesPopContainer"],[583,".ck-sp-app-wrapper"],[833,".js-pn.payment-notification"],[1490,".noti-container-main"],[512,".source-woocommerce.nx-notification"],[284,".wpcsn-notification-inner"],[2812,".yo-notification"],[1189,".es-badge-container"],[1627,".vjs-pip-y-bottom"],[931,"div.l > .acu.act"],[740,"#credential_picker_container"],[1568,"#credential_picker_iframe,\n#btn-back-top,\n#scrolltotop_button"],[495,"#consumer-app > #navbar-wrap > .pm-root-announcement,\n#consumer-app > .modals-wrap > .pm-follow-v2"],[287,".pm-follow-wrap"],[3669,".bp-banner"],[1217,"#hot-jobs"],[1281,".js-stickyFooter.u-bottom0.u-fixed"],[3280,".postActionsBar-container"],[1676,".u-zIndexMetabar.u-fixed"],[1129,"#back-to-home > .back-to-home-button,\n.tornasu"],[3017,"#close-btn-wrapper > #close-back-btn"],[2981,".article-section > .ui-button-close"],[347,".close-wrap > .close-overlay,\n#block-backtotop"],[1379,".gnt_m_fs.gnt_m"],[261,"#nca-behavioural-banner-wrapper"],[1103,".RelatedStoriesSupportUsComboInlineContentresponsive,\n#linkbacktop_top"],[1666,".cm-failsafe"],[80,".cm-hero-container"],[448,".consumer-marketing-unit--article-mid-content"],[919,".cta_magazine_subscription_wrap"],[2955,".ecom-placement,\n#go-to-top,\n#gp-to-top"],[2575,".ecom-promo2"],[1309,".featured-post-banner__newsletter-signup"],[1946,".g-cta-subscribe"],[3925,".hdr-sub-ad-01"],[487,".nca-block-promo-banner"],[165,".newsblock-support-cta"],[1851,".newsltter-iframe"],[800,".pn-single-post-wrapper__newsletter-signup"],[199,".subscription-tout"],[330,"#floaty-rss,\n.fjs-scroll-to-top"],[3698,"#follow-rss"],[2331,"#footer-rss,\n.back-to-top-link"],[2823,"#footerrss"],[469,"#rightSocialRss"],[2225,"#rss-subscribe"],[1211,"#rsslisting"],[686,"#sidebar-rss"],[3155,"#social-links-rss"],[90,".addthis-rss"],[3754,".follow-link-rss"],[2431,".follow-rss"],[1635,".followRSS"],[1918,".follow__rss,\n.os-back-to-top"],[3947,".follow_us_rss"],[3414,".footer-rss"],[1781,".footerButtonRSS"],[1034,".footerRSS"],[158,".p-footer-rssLink,\n.g1-back-to-top-on"],[1712,".rss-blogroll,\n.JumpToTop"],[2825,".rss-footer"],[1157,".widget_rssiconwidget"],[3853,"#ArrowToTop,\n#toPagetop"],[3451,"#BackToTop"],[3836,"#BtmToPageTopArea"],[1000,"#Imgback2top"],[1138,"#J_returntop"],[3700,"#PAGE_TOP_LINK"],[1836,"#ReturnToTop"],[1807,"#ScrollToTopButton"],[891,"#ScrollToTopContainer"],[559,"#T-Hoch-Btn"],[3476,"#ToTopButtom,\n.zr_alerts_widget_link"],[3621,"#WidgetScrollToTop"],[2232,"#arrow-scroll-top"],[1169,"#arrow_to_site_top,\n.hse-scrolltotop"],[247,"#ast-scroll-top"],[1974,"#auto-top-link"],[954,"#back-to-the-top"],[2517,"#back-to-top-arrow"],[3687,"#back-to-top-btn"],[1326,"#back-to-top-button"],[3026,"#back-to-top-icon"],[772,"#back-to-top-scroll"],[2278,"#back-top"],[2965,"#back-top-btn"],[2958,"#back-top-top"],[409,"#back2top"],[530,"#backToTopButton"],[1900,"#backToTop_RT"],[271,"#backtotop-scroll,\n.site-scroll-top"],[3666,"#backtotopbutton"],[637,"#backtotoplink"],[925,"#base_scrollToTop"],[3260,"#bigslam-footer-back-to-top-button"],[79,"#bktotopbtn"],[515,"#bt-backtop"],[3557,"#bt-scroll-top,\n#bw-scroll-top"],[430,"#btn--back-to-top"],[1440,"#btn-go-top"],[2322,"#btn-scroll-up"],[3443,"#btn-to-top"],[2288,"#btn_backtt"],[1845,"#btn_control_totop"],[3857,"#button-to-top"],[2907,"#button-totop"],[700,"#buttonScrollTop"],[722,"#c-backtotop-btn"],[2959,"#cb-to-top"],[2493,"#cw_to_top"],[275,"#divGoTop,\n#go-to-bottom"],[308,"#div_gotop_outer"],[2847,"#dynamic-to-top"],[970,"#edgtf-back-to-top"],[3034,"#eltdf-back-to-top"],[3727,"#fav-backtotop"],[1226,"#fl-to-top"],[3076,"#float-btn-backtotop"],[2579,"#footer-0-BackToTop"],[2093,"#footer-back-to-top"],[4029,"#footer-to_top_button"],[526,"#footer_scroll_top"],[251,"#g1-back-to-top"],[2866,"#gh-bt"],[1899,"#gkTopLink"],[1463,"#goDownFooter"],[2716,"#goToTop"],[3190,"#goToTopButton"],[2323,"#goToUp"],[1538,"#goTopFooter"],[3710,"#goto-top"],[3382,"#goto-top-page,\n.site-footer__back-to-top"],[2876,"#gotoTop"],[2301,"#gotoTopWrapper"],[2908,"#gototop:not(body),\n.rail > .ad_spot + .most-popular"],[294,"#imPageToTop"],[3559,"#img_goTop"],[208,"#inline-related-post"],[3261,"#int-btn-top"],[1771,"#iron-back-top"],[652,"#jGoTop"],[3220,"#jas-backtop"],[2063,"#jiordano-totop"],[4001,"#jm-back-top"],[2870,"#js-back-to-top"],[2818,"#js-backtoTop"],[2840,"#js-btnGoTop,\n.fwscrolltotop"],[1336,"#js-pagetop-btn"],[2827,"#jsn-gotoplink"],[2217,"#jump-to-top"],[2735,"#jump-top"],[3870,"#jwDisqusBackToTop"],[3150,"#ktz-backtotop"],[101,"#layoutscrolltop"],[620,"#mainToTopAnchor"],[2542,"#main_scroll_icon"],[193,"#menu-back-to-top"],[393,"#mgs-scrollup"],[2498,"#mkd-back-to-top"],[2379,"#mkdf-back-to-top,\n.o-back-to-top"],[3029,"#move-to-top"],[1639,"#move_to_top"],[3800,"#mt-scrollup"],[2781,"#navBackToTop"],[1183,"#neklo_scrolltotop_arrow"],[3902,"#nino-scrollToTop"],[1915,"#np-scrollup,\n#nv-scrollup,\n.button-back-top"],[1820,"#onTop3"],[1993,"#pageStick-Backtop-btn,\n.body-back-to-top"],[1936,"#pagescrolltop"],[1413,"#picto-to-top"],[3756,"#pix--totop"],[317,"#pl_common_scrollToTop"],[2543,"#pojo-scroll-up"],[3293,"#pro-scroll-top"],[655,"#qodef-back-to-top,\n.jsbd-Backtotop"],[2396,"#return-to-top"],[3671,"#returnOnTop"],[2734,"#return_to_top"],[1400,"#sbttBacktotop"],[163,"#scrl-top"],[3177,"#scroll-top-button"],[1068,"#scroll-top-link"],[832,"#scroll-top-top"],[2720,"#scroll-toplink"],[3770,"#scroll-up-button"],[431,"#scrollToTopButton"],[1911,"#scroll_to_top"],[1798,"#scroll_top_div,\n.box-scrollToTop,\n.go-top,\n.pgevoke-backtotop"],[588,"#scroll_top_wrap"],[3517,"#scroll_totop"],[2153,"#scrolltoptop"],[2357,"#scrolltotop"],[3108,"#scrollup_button"],[482,"#site-scroll-top"],[2256,"#siteBackToTop_small_box"],[2789,"#spnGoTop"],[1743,"#sticky-back-to-top,\n.go-top-wrapper"],[3315,"#sttotop"],[3817,"#tab-to-top"],[4071,"#tbScrollToTop,\n.arrow_scroll_up"],[459,"#tc-footer-btt-wrapper"],[3609,"#theme-go-to-top"],[250,"#to-top-button"],[511,"#to-top-container"],[2065,"#to-top-link"],[4024,"#toTo_button"],[3064,"#toTopLink"],[42,"#to_top:not(body)"],[519,"#to_top_scrollup"],[2107,"#top-to-top,\n.hm_go_top"],[2020,"#tornasu"],[1346,"#tothetop"],[2222,"#tothetopbtn"],[2166,"#totop-btn"],[309,"#totop-scroller,\n.scroll-to-top-square:not(body)"],[2083,"#totopBtn"],[1100,"#totopscroller"],[1960,"#ts-back-to-top"],[3505,"#tweScrollTop"],[25,"#ui-to-top,\n#up-to-top"],[1320,"#uiGoToTop"],[2600,"#uix_jumpToFixed"],[177,"#uix_jumpToTopFixed"],[1450,"#ultra-go-top"],[1442,"#up_scroll_arrow"],[998,"#volver-arriba"],[783,"#w2b-StoTop"],[142,"#wp-smooth-scroll"],[3473,"#wpfront-scroll-top-container"],[2539,"#wrap-scroll-toplink"],[168,"#xb_ScrollDown"],[4086,".BackToTop"],[1014,".Backtotop"],[3692,".Bt_Gotop"],[2144,".Button-BackToTop,\n.jsButtonToTop"],[3049,".ButtonBackToTop"],[468,".Footer__backToTopButton"],[2974,".GlobalFooter-backToTop"],[4062,".GlobalFooter-backToTopSection"],[3722,".NextCheatButton"],[847,".Page-footer-back-to-top"],[1725,".PageHeaderWithMenu-backTop"],[2030,".ScrollTop"],[241,".SiteScrollToTopButton"],[398,".TopGoTop"],[2562,".W_gotop"],[2885,".a-back-to-top"],[2567,".a-core-scroll-to-top"],[3551,".ab__scroll_to_top"],[1575,".adept-back_to_top,\n.button--toTop"],[564,".ant-back-top"],[1765,".arrow_up"],[3570,".artee-back-to-top"],[257,".article-back-to-top"],[737,".article-return-to-top"],[971,".aside-backtop"],[1571,".aside-item-top"],[3823,".aux-goto-top-btn"],[2047,".axScrollToTop"],[1670,".b-back-to-top"],[3036,".b-button-to-top"],[86,".b-footer__btn_up"],[2952,".b-scroll-to-top"],[890,".b-scroll_to_top"],[266,".back-to-top-btn"],[963,".back-to-top-button,\n.back-to-top_button"],[3051,".back-to-top-container"],[484,".back-to-top-cta,\n.c-back-top"],[485,".back-to-top-sticky,\n.btn--toTop"],[2287,".back-to-top-wrap"],[1313,".back-to-top-wrapper"],[3266,".back-to-top:not(body):not(html)"],[1681,".back-to-top__button"],[1803,".back-top"],[1528,".back-top-btn"],[1507,".back-top-top"],[2194,".back-top_button"],[2804,".back2top"],[1558,".backToTop"],[2495,".backToTopButton"],[3263,".backToTopIcon"],[4035,".backToTopVisible"],[4066,".backTopLink"],[2585,".back_Top"],[640,".back_Top_Icon"],[1979,".back_Top_wp"],[560,".back_to_top,\n.footer__nav-to-top"],[2345,".back_to_top_link"],[1964,".back_top_bg"],[1789,".back_up_but"],[3219,".backto-top"],[534,".backtotop"],[2147,".backtotop-bubble"],[1471,".backtotopbutton"],[437,".backtotopx"],[572,".bc_goto_top"],[1141,".bcp-block-back-to-top"],[206,".bfc-scroll-to-top,\n.btn-scroll-to-top"],[1585,".bigslam-footer-back-to-top-button"],[2240,".block_to_top"],[2690,".blog-back-to-top"],[1343,".body-btn-top"],[2923,".bof-scroll-top"],[2069,".bottom-scroll-top"],[1664,".bt-pagetop"],[1283,".btn--move-to-top"],[2058,".btn-back-to-top"],[930,".btn-cmn-pagetop-wrap"],[429,".btn-go-top"],[1599,".btn-goto-top,\n.button-scroll-to-top"],[2810,".btn-return-top"],[3683,".btn-scroll-top"],[2911,".btn-scroll-up"],[510,".btn-to-top"],[3319,".btn-top[href^=\"#\"]"],[1121,".btn-tw-backtotop"],[2421,".btn.gotop"],[456,".btn2top"],[173,".btnBackTop"],[3837,".btn_backtt"],[670,".btn_gototop"],[1116,".button--scroll-top"],[1452,".button-go-up"],[3932,".button-to-top"],[1512,".bw-scroll-top"],[1095,".c-back-to-top,\n.simplifytotop"],[249,".c-back-to-top-cta"],[910,".c-footer__back-to-top"],[1047,".c-totop"],[1335,".c_pagetop"],[3539,".category-page__back-to-top--button"],[2877,".ccm_go_top"],[3959,".cp-footer-scroll-top"],[2354,".crc-backToTop"],[2237,".ct-js-btnScrollUp"],[2479,".ct-scrollUpButton"],[1004,".ct-totop,\n#searchform > #gb > #gbw .gb_Mc[aria-label=\"promo\"] > .gb_ea,\n#searchform > #gb > #gbw .gb_Vc[aria-label=\"promo\"] > .gb_ga"],[3685,".custom-back-to-top"],[1797,".dc-go-top"],[105,".dmtop,\n.penci-go-to-top-floating"],[1398,".dp-footer__to-top"],[3825,".dvt-go-top"],[3554,".eb-toc-go-top,\n.js-toTop"],[1200,".ef3-back-to-top"],[1519,".enigma_scrollup"],[2555,".et_pb_scroll_top"],[432,".eut-back-top"],[4050,".f-footer__btn_up"],[2499,".f-go-top"],[2615,".fi-back-to-top"],[228,".fk-ui-goTop"],[3873,".fk_siteBackToTop"],[3968,".footer--scrolltop"],[3442,".footer--totop"],[1216,".footer-back-to-top,\n.return_top"],[558,".footer-back-top"],[2709,".footer-backtotop"],[85,".footer-button-top"],[717,".footer-link-to-top"],[643,".footer-scroll-totop"],[873,".footer-to-top"],[2836,".footer-top-of-page"],[1436,".footerBackToTop"],[2741,".footerBackToTopLink"],[1153,".footer__back-to-top"],[513,".footer__back-to-top-button"],[3739,".footer__back-to-top-container"],[3406,".footer__backtotop-btn"],[413,".footer__go-to-top"],[301,".footernavigation__scrollUp"],[1910,".g1-back-to-top"],[3118,".ga-scrolltop-anchor"],[3961,".gantry-totop-wrapper"],[3077,".generate-back-to-top"],[3650,".gn-backtotop"],[4038,".go-to-top"],[2392,".go-to-top--btn"],[2468,".go-to-top-arrow"],[1638,".go-to-top-button"],[630,".go-to-top-page"],[4068,".go-top-button"],[3477,".go-top2"],[1809,".go-up-btn"],[4025,".go2top"],[421,".goBackTop"],[3153,".goToTop"],[2793,".goTopButton,\n.pi-scroll-top-arrow"],[1332,".go_to_top"],[2123,".go_top_scroll"],[1391,".goto-anchor-top"],[1555,".goto-top"],[2722,".goto-top-container"],[3816,".gotop-btn,\n.gotop_btn"],[2004,".gotop-wrapper"],[3345,".gototop"],[2088,".goup-container"],[632,".gpe_movetop"],[627,".gr-footer-back-top"],[2449,".greatwp-scroll-top"],[671,".gs18-GoTop"],[3637,".hestia-scroll-to-top"],[1769,".icon-back-to-top"],[1368,".infinite-footer-back-to-top-button"],[296,".ins-backtotop"],[3041,".is-totop"],[30,".itemBackToTop"],[3764,".itw-scrollTop"],[1405,".ivu-back-top"],[3934,".j-footer__btn_up"],[541,".jquery-back-to-top"],[3336,".js--scroll-top,\n.layout__scroll-to-top,\n.prodToTop"],[2875,".js-back-to-top"],[88,".js-back-to-top-story"],[1647,".js-backToTop"],[1433,".js-button-totop"],[1160,".js-pageTop"],[3463,".js-persistent-nav-top"],[992,".js-scroll-top:not(html):not(body)"],[3786,".js-scrollTop"],[1714,".js-scroll_to_bottom"],[3101,".js-scroll_to_top"],[1493,".js-top-btn"],[2439,".js_Link_GoUp"],[2611,".js__back-to-top"],[4060,".js_btn_gotop"],[466,".js_go_up"],[3474,".js_scroll_top"],[1721,".js_to-top"],[3086,".jscroll-to-top_link"],[3396,".jump-to-top"],[1869,".jupiterx-scroll-top"],[3674,".kleanity-footer-back-to-top-button"],[1837,".kleo-go-top"],[1416,".layoutscrolltop"],[3340,".lia-component-common-widget-scroll-to"],[4069,".link_GoUp"],[1011,".link_to_top"],[4072,".m-ButtonScrollTop"],[73,".m-back-to-top"],[1192,".m-go-top"],[2848,".m-scroll-top"],[2820,".main-icon--pagetop"],[3549,".material-scrolltop"],[172,".menu-back-to-top,\n.scroll-to-top-button"],[4092,".mh-back-to-top"],[1850,".mintwp-scroll-top"],[332,".mk-go-top"],[1251,".mnmd-go-top"],[446,".mod-totop"],[2018,".ms-scroll-to-top-button"],[1603,".mvp-fly-top"],[4079,".mvp-to-top"],[3069,".mypresta_scrollup"],[2519,".nav--back-to-top,\n.ta_back-to-top"],[3372,".navigate-to-top"],[3821,".o-backtop"],[725,".on--totop"],[3616,".oui-back-to-top"],[108,".p-pagetop-btn"],[3410,".page-to-top-visible"],[698,".pagetop-btn"],[1953,".pb-back-to-top"],[2536,".picto-to-top"],[2977,".pix--totop"],[2912,".q-back-to-top-button"],[3767,".q-mod-back-to-top-button"],[1248,".qc-back-to-top"],[1531,".qw-scrollbutton-top"],[3601,".remonter-la-page"],[3996,".retour_haut"],[1297,".return-to-top"],[801,".returnToTop"],[2389,".rh-footer-back-to-top"],[3275,".rlx-back-top"],[3588,".rtp-back-to-top"],[2064,".ruby-back-top"],[3993,".s-btn-gotop"],[2803,".s-f-back-to-top"],[2340,".s-gotop-wrap"],[2380,".s5_scrolltotop"],[3170,".sc-back-to-top,\n.sf-back-to-top,\n.sh-back-to-top"],[2246,".scroll-back-to-top-wrapper"],[3252,".scroll-to-top-arrow"],[2151,".scroll-to-top-btn"],[110,".scroll-to-top-class"],[2681,".scroll-to-top-link"],[2680,".scroll-to-top-show"],[3848,".scroll-to-top.btn"],[8,".scroll-to.top"],[225,".scroll-top-arrow"],[3862,".scroll-top-btn"],[3460,".scroll-top-button"],[375,".scroll-top-inner"],[2559,".scroll-top-wrapper"],[3927,".scroll-up-button"],[690,".scroll-up-button-wrapper"],[753,".scroll-up-cta"],[2516,".scroll2top"],[984,".scrollToTop"],[265,".scrollToTopBtn"],[770,".scrollToTopButton"],[1214,".scrollToTopLink"],[1325,".scrollToTopText"],[3499,".scrollTo_top"],[3047,".scrollTopButton"],[529,".scrollUp-child"],[604,".scroll__to__top"],[755,".scroll__top"],[1786,".scroll_to_top"],[243,".scroll_to_top_icon"],[854,".scroll_top_btn"],[1996,".scrollbtntop"],[1355,".scrollto_top"],[166,".scrolltop-btn"],[3874,".scrolltotopbutton"],[3436,".scrollup-container"],[2829,".scroolTop:not(body):not(html)"],[1693,".show-top-button"],[2638,".shunno-top"],[1719,".single-scroll-top"],[3035,".siteAside_toTop"],[1500,".siteFooter__goTop"],[3611,".slideToTop"],[2706,".sm-page-scroll-to-top"],[361,".sp-scroll-up"],[1122,".st-site-scroll-top,\n.tornaSuBtn"],[674,".sticky-back-to-top"],[2187,".stotop"],[3464,".stp--nav-to-top"],[1804,".styliumToTop"],[252,".sublink_back_top"],[754,".sunfw-scrollup"],[356,".tab-to-top"],[113,".tb-scroll-to-top"],[1701,".tc-back-to-top"],[647,".tc-btt-wrapper"],[2318,".td-scroll-up"],[2157,".td-scroll-up-visible"],[2086,".tdr-backtop"],[1164,".ti_scroll"],[2046,".tm-scroll-top"],[3606,".to-pagetop"],[279,".to-the-top"],[3531,".to-top-btn"],[3580,".to-top-link"],[175,".toTheTop"],[2990,".toTopBtn"],[1509,".toTopBtnF"],[2778,".toTopButton"],[1559,".to_the_top"],[3262,".top-of-page-link"],[3777,".topofpage"],[2601,".torimochi-widget"],[235,".torna-su"],[2121,".tornaSu"],[2265,".torna_su"],[1455,".tothetop"],[747,".totop_button"],[3065,".totopbuttom"],[3066,".totopbutton"],[435,".txt_back_top"],[2131,".u-scrollButtons"],[996,".ui-back-to-top"],[2320,".ui-backtotop,\n.w-gotop"],[3083,".ui-fixed-panel-go-top"],[852,".ui-go-top,\n.ui-to-top,\n.up-to-top"],[3960,".ui-scrollToTop"],[236,".verso-go-top"],[2343,".visible.scroll-to-top"],[1971,".vw-scroll-to-top"],[2914,".vw_m511_back_top"],[3657,".vw_m520_topbar"],[790,".w-toplink"],[3358,".widget-goto-top"],[982,".wp-to-top"],[1784,".yjscroll"],[1266,".yukari_git"],[3869,"div#back_to_top"],[161,"#zipsearch_container"],[3771,".zr_alerts_widget_container"],[2214,".format-standard > .fixed-article-nav"],[2682,".ad400"],[1066,"#inner-wrap > .slide-dock-on"],[381,".site-content > .slide-dock-on"],[3550,".promotional.header--offset.header-breaking__wrapper"],[2216,".gnt_ar_xb"],[1499,".screenContent > .u-bottom0"],[2458,".odkl-klass-stat"]];
const genericExceptionSieve = [2955,2716,3710,1911,2357,42,694,989,574,3051,3266,2058,2875,992];
const genericExceptionMap = [["portalvirtualreality.ru","#go-to-top"],["mercopress.com","#goToTop"],["lecyclo.com","#goto-top"],["temaretik.com","#scroll_to_top"],["wedevs.com","#scrolltotop"],["polcol.ru","#to_top:not(body)"],["vamk33.ru","#to_top:not(body)"],["uservoice.com","#uservoice-feedback\n#uservoice-feedback-tab"],["cnn.com",".OUTBRAIN"],["dell.com",".back-to-top-container"],["skadden.com",".back-to-top:not(body):not(html)\n.js-back-to-top"],["realme.com",".btn-back-to-top"],["midori-japan.co.jp",".js-scroll-top:not(html):not(body)"]];

if ( genericSelectorMap ) {
    const map = self.genericSelectorMap =
        self.genericSelectorMap || new Map();
    if ( map.size !== 0 ) {
        for ( const entry of genericSelectorMap ) {
            const before = map.get(entry[0]);
            if ( before === undefined ) {
                map.set(entry[0], entry[1]);
            } else {
                map.set(entry[0], `${before},\n${entry[1]}`);
            }
        }
    } else {
        self.genericSelectorMap = new Map(genericSelectorMap);
    }
    genericSelectorMap.length = 0;
}

if ( genericExceptionSieve ) {
    const hashes = self.genericExceptionSieve =
        self.genericExceptionSieve || new Set();
    if ( hashes.size !== 0 ) {
        for ( const hash of genericExceptionSieve ) {
            hashes.add(hash);
        }
    } else {
        self.genericExceptionSieve = new Set(genericExceptionSieve);
    }
    genericExceptionSieve.length = 0;
}

if ( genericExceptionMap ) {
    const map = self.genericExceptionMap =
        self.genericExceptionMap || new Map();
    if ( map.size !== 0 ) {
        for ( const entry of genericExceptionMap ) {
            const before = map.get(entry[0]);
            if ( before === undefined ) {
                map.set(entry[0], entry[1]);
            } else {
                map.set(entry[0], `${before}\n${entry[1]}`);
            }
        }
    } else {
        self.genericExceptionMap = new Map(genericExceptionMap);
    }
    genericExceptionMap.length = 0;
}

/******************************************************************************/

})();

/******************************************************************************/
